/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.CreateTableNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FKConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ModifyColumnNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.ConstraintInfo;
import org.apache.derby.impl.sql.execute.IndexConstantAction;

public class TableElementList
extends QueryTreeNodeVector {
    int numColumns;
    TableDescriptor td;

    public void addTableElement(TableElementNode tableElementNode) {
        this.addElement(tableElementNode);
        if (tableElementNode instanceof ColumnDefinitionNode || tableElementNode.getElementType() == 7) {
            ++this.numColumns;
        }
    }

    public String toString() {
        return "";
    }

    void validate(DDLStatementNode dDLStatementNode, DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList;
        this.td = tableDescriptor;
        int n = 0;
        int n2 = this.size();
        Hashtable hashtable = new Hashtable(n2 + 2, 0.999f);
        Hashtable hashtable2 = new Hashtable(n2 + 2, 0.999f);
        Vector<Object> vector = new Vector<Object>();
        if (tableDescriptor != null && (constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor)) != null) {
            int n3 = 0;
            while (n3 < constraintDescriptorList.size()) {
                ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(n3);
                if (constraintDescriptor.getConstraintType() == 2 || constraintDescriptor.getConstraintType() == 3) {
                    vector.addElement(constraintDescriptor);
                }
                ++n3;
            }
        }
        int n4 = 0;
        if (dDLStatementNode instanceof CreateTableNode) {
            n4 = ((CreateTableNode)dDLStatementNode).tableType;
        }
        int n5 = 0;
        while (n5 < n2) {
            Object object;
            Object object2;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(n5);
            if (tableElementNode instanceof ColumnDefinitionNode) {
                object2 = (ColumnDefinitionNode)this.elementAt(n5);
                if (n4 == 3 && (((ColumnDefinitionNode)object2).getDataTypeServices().getTypeId().isLongConcatableTypeId() || ((ColumnDefinitionNode)object2).getDataTypeServices().getTypeId().isUserDefinedTypeId())) {
                    throw StandardException.newException("42962", ((ColumnDefinitionNode)object2).getColumnName());
                }
                this.checkForDuplicateColumns(dDLStatementNode, hashtable, ((ColumnDefinitionNode)object2).getColumnName());
                ((ColumnDefinitionNode)object2).checkUserType(tableDescriptor);
                ((ColumnDefinitionNode)object2).bindAndValidateDefault(dataDictionary, tableDescriptor);
                ((ColumnDefinitionNode)object2).validateAutoincrement(dataDictionary, tableDescriptor, n4);
                if (tableElementNode instanceof ModifyColumnNode) {
                    object = (ModifyColumnNode)object2;
                    ((ModifyColumnNode)object).checkExistingConstraints(tableDescriptor);
                } else if (((ColumnDefinitionNode)object2).isAutoincrementColumn()) {
                    ++n;
                }
            } else if (tableElementNode.getElementType() == 7) {
                object2 = tableElementNode.getName();
                if (tableDescriptor.getColumnDescriptor((String)object2) != null) break;
                throw StandardException.newException("42X14", object2, (Object)tableDescriptor.getQualifiedName());
            }
            if (tableElementNode.hasConstraint()) {
                Object object3;
                String string;
                object2 = (ConstraintDefinitionNode)tableElementNode;
                ((ConstraintDefinitionNode)object2).bind(dDLStatementNode, dataDictionary);
                if (((ConstraintDefinitionNode)object2).getConstraintType() == 2 || ((ConstraintDefinitionNode)object2).getConstraintType() == 3) {
                    string = null;
                    object3 = null;
                    int n6 = 0;
                    while (n6 < vector.size()) {
                        Object object4;
                        object = vector.elementAt(n6);
                        if (object instanceof ConstraintDefinitionNode) {
                            object4 = (ConstraintDefinitionNode)object;
                            string = ((ConstraintDefinitionNode)object4).getConstraintMoniker();
                            object3 = ((ConstraintDefinitionNode)object4).getColumnList().getColumnNames();
                        } else if (object instanceof ConstraintDescriptor) {
                            object4 = (ConstraintDescriptor)object;
                            string = ((ConstraintDescriptor)object4).getConstraintName();
                            object3 = ((ConstraintDescriptor)object4).getColumnDescriptors().getColumnNames();
                        }
                        if (this.columnsMatch(((ConstraintDefinitionNode)object2).getColumnList().getColumnNames(), (String[])object3)) {
                            throw StandardException.newException("42Z93", ((ConstraintDefinitionNode)object2).getConstraintMoniker(), (Object)string);
                        }
                        ++n6;
                    }
                    vector.addElement(object2);
                }
                if (object2 instanceof ConstraintDefinitionNode) {
                    this.checkForDuplicateConstraintNames(dDLStatementNode, hashtable2, ((ConstraintDefinitionNode)object2).getConstraintMoniker());
                }
                if (((ConstraintDefinitionNode)object2).getConstraintType() == 5 && (object = ((ConstraintDefinitionNode)object2).getConstraintMoniker()) != null) {
                    string = ((ConstraintDefinitionNode)object2).getDropSchemaName();
                    object3 = string == null ? tableDescriptor.getSchemaDescriptor() : this.getSchemaDescriptor(string);
                    ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptorByName(tableDescriptor, (SchemaDescriptor)object3, (String)object, false);
                    if (constraintDescriptor == null) {
                        throw StandardException.newException("42X86", object3.getSchemaName() + "." + (String)object, (Object)tableDescriptor.getQualifiedName());
                    }
                    this.getCompilerContext().createDependency(constraintDescriptor);
                }
                if (((ConstraintDefinitionNode)object2).hasPrimaryKeyConstraint() || ((ConstraintDefinitionNode)object2).hasForeignKeyConstraint() || ((ConstraintDefinitionNode)object2).hasUniqueKeyConstraint()) {
                    this.verifyUniqueColumnList(dDLStatementNode, (ConstraintDefinitionNode)object2);
                    if (((ConstraintDefinitionNode)object2).hasPrimaryKeyConstraint() || ((ConstraintDefinitionNode)object2).hasUniqueKeyConstraint()) {
                        this.setColumnListToNotNull((ConstraintDefinitionNode)object2, tableDescriptor);
                    }
                }
            }
            ++n5;
        }
        if (n > 1) {
            throw StandardException.newException("428C1");
        }
    }

    public int countConstraints(int n) {
        int n2 = 0;
        int n3 = this.size();
        int n4 = 0;
        while (n4 < n3) {
            ConstraintDefinitionNode constraintDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(n4);
            if (tableElementNode instanceof ConstraintDefinitionNode && n == (constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode).getConstraintType()) {
                ++n2;
            }
            ++n4;
        }
        return n2;
    }

    public int countNumberOfColumns() {
        return this.numColumns;
    }

    public int genColumnInfos(ColumnInfo[] columnInfoArray) {
        int n = 0;
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            if (((TableElementNode)this.elementAt(n3)).getElementType() == 7) {
                columnInfoArray[n3] = new ColumnInfo(((TableElementNode)this.elementAt(n3)).getName(), null, null, null, null, null, 2, 0L, 0L);
                break;
            }
            if (!(this.elementAt(n3) instanceof ColumnDefinitionNode)) {
                ++n;
            } else {
                ColumnDefinitionNode columnDefinitionNode = (ColumnDefinitionNode)this.elementAt(n3);
                columnInfoArray[n3 - n] = new ColumnInfo(columnDefinitionNode.getColumnName(), columnDefinitionNode.getDataTypeServices(), columnDefinitionNode.getDefaultValue(), columnDefinitionNode.getDefaultInfo(), null, columnDefinitionNode.getOldDefaultUUID(), columnDefinitionNode.getAction(), columnDefinitionNode.isAutoincrementColumn() ? columnDefinitionNode.getAutoincrementStart() : 0L, columnDefinitionNode.isAutoincrementColumn() ? columnDefinitionNode.getAutoincrementIncrement() : 0L);
                if (columnDefinitionNode.hasConstraint()) {
                    ++n;
                }
            }
            ++n3;
        }
        return n;
    }

    public void appendNewColumnsToRCL(FromBaseTable fromBaseTable) throws StandardException {
        int n = this.size();
        ResultColumnList resultColumnList = fromBaseTable.getResultColumns();
        TableName tableName = fromBaseTable.getTableName();
        int n2 = 0;
        while (n2 < n) {
            if (this.elementAt(n2) instanceof ColumnDefinitionNode) {
                ColumnDefinitionNode columnDefinitionNode = (ColumnDefinitionNode)this.elementAt(n2);
                ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, columnDefinitionNode.getColumnName(), tableName, columnDefinitionNode.getDataTypeServices(), this.getContextManager());
                ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnDefinitionNode.getDataTypeServices(), valueNode, this.getContextManager());
                resultColumn.setName(columnDefinitionNode.getColumnName());
                resultColumnList.addElement(resultColumn);
            }
            ++n2;
        }
    }

    void bindAndValidateCheckConstraints(FromList fromList) throws StandardException {
        FromBaseTable fromBaseTable = (FromBaseTable)fromList.elementAt(0);
        int n = this.size();
        CompilerContext compilerContext = this.getCompilerContext();
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < n) {
            ConstraintDefinitionNode constraintDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(n2);
            if (tableElementNode instanceof ConstraintDefinitionNode && (constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode).getConstraintType() == 4) {
                Object object;
                ValueNode valueNode = constraintDefinitionNode.getCheckCondition();
                int n3 = compilerContext.getReliability();
                try {
                    object = new ProviderList();
                    ProviderList providerList = compilerContext.getCurrentAuxiliaryProviderList();
                    compilerContext.setCurrentAuxiliaryProviderList((ProviderList)object);
                    compilerContext.setReliability(1657);
                    valueNode = valueNode.bindExpression(fromList, null, vector);
                    if (vector.size() != 0) {
                        throw StandardException.newException("42Y01", constraintDefinitionNode.getConstraintText());
                    }
                    valueNode = valueNode.checkIsBoolean();
                    constraintDefinitionNode.setCheckCondition(valueNode);
                    if (((Hashtable)object).size() > 0) {
                        constraintDefinitionNode.setAuxiliaryProviderList((ProviderList)object);
                    }
                    compilerContext.setCurrentAuxiliaryProviderList(providerList);
                }
                finally {
                    Object var12_11 = null;
                    compilerContext.setReliability(n3);
                }
                object = fromBaseTable.getResultColumns();
                int n4 = ((ResultColumnList)object).countReferencedColumns();
                int[] nArray = new int[n4];
                ((ResultColumnList)object).recordColumnReferences(nArray, 1);
                constraintDefinitionNode.setCheckColumnReferences(nArray);
                ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
                ((ResultColumnList)object).copyReferencedColumnsToNewList(resultColumnList);
                if (constraintDefinitionNode.getColumnList() != null) {
                    String string = ((ResultColumn)constraintDefinitionNode.getColumnList().elementAt(0)).getName();
                    if (n4 > 1 || !string.equals(((ResultColumn)resultColumnList.elementAt(0)).getName())) {
                        throw StandardException.newException("42621", string);
                    }
                }
                constraintDefinitionNode.setColumnList(resultColumnList);
                ((ResultColumnList)object).clearColumnReferences();
            }
            ++n2;
        }
    }

    void genConstraintActions(ConstraintConstantAction[] constraintConstantActionArray, String string, SchemaDescriptor schemaDescriptor, DataDictionary dataDictionary) throws StandardException {
        int n = this.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String[] stringArray = null;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(n3);
            IndexConstantAction indexConstantAction = null;
            if (tableElementNode.hasConstraint() && !(tableElementNode instanceof ColumnDefinitionNode)) {
                ConstraintDefinitionNode constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode;
                if (constraintDefinitionNode.getColumnList() != null) {
                    stringArray = new String[constraintDefinitionNode.getColumnList().size()];
                    constraintDefinitionNode.getColumnList().exportNames(stringArray);
                }
                int n4 = constraintDefinitionNode.getConstraintType();
                String string2 = constraintDefinitionNode.getConstraintText();
                String string3 = constraintDefinitionNode.getConstraintMoniker();
                if (constraintDefinitionNode.requiresBackingIndex()) {
                    indexConstantAction = this.genIndexAction(constraintDefinitionNode.requiresUniqueIndex(), null, constraintDefinitionNode, stringArray, true, schemaDescriptor, string, n4, dataDictionary);
                }
                if (n4 == 5) {
                    constraintConstantActionArray[n2] = this.getGenericConstantActionFactory().getDropConstraintConstantAction(string3, constraintDefinitionNode.getDropSchemaName(), string, this.td.getUUID(), schemaDescriptor.getSchemaName(), indexConstantAction, constraintDefinitionNode.getDropBehavior(), constraintDefinitionNode.getVerifyType());
                } else {
                    ProviderList providerList = constraintDefinitionNode.getAuxiliaryProviderList();
                    ConstraintInfo constraintInfo = null;
                    ProviderInfo[] providerInfoArray = null;
                    if (constraintDefinitionNode instanceof FKConstraintDefinitionNode) {
                        constraintInfo = ((FKConstraintDefinitionNode)constraintDefinitionNode).getReferencedConstraintInfo();
                    }
                    if (providerList != null && providerList.size() > 0) {
                        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
                        providerInfoArray = dependencyManager.getPersistentProviderInfos(providerList);
                    } else {
                        providerInfoArray = new ProviderInfo[]{};
                    }
                    constraintConstantActionArray[n2++] = this.getGenericConstantActionFactory().getCreateConstraintConstantAction(string3, n4, string, this.td != null ? this.td.getUUID() : null, schemaDescriptor.getSchemaName(), stringArray, indexConstantAction, string2, true, constraintInfo, providerInfoArray);
                }
            }
            ++n3;
        }
    }

    private boolean columnsMatch(String[] stringArray, String[] stringArray2) throws StandardException {
        boolean bl = true;
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = stringArray.length;
        int n2 = stringArray2.length;
        int n3 = 0;
        while (n3 < n) {
            bl = false;
            int n4 = 0;
            while (n4 < n2) {
                if (stringArray[n3].equals(stringArray2[n4])) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private IndexConstantAction genIndexAction(boolean bl, String string, ConstraintDefinitionNode constraintDefinitionNode, String[] stringArray, boolean bl2, SchemaDescriptor schemaDescriptor, String string2, int n, DataDictionary dataDictionary) throws StandardException {
        if (string == null) {
            string = constraintDefinitionNode.getBackingIndexName(dataDictionary);
        }
        if (n == 5) {
            return this.getGenericConstantActionFactory().getDropIndexConstantAction(null, string, string2, schemaDescriptor.getSchemaName(), this.td.getUUID(), this.td.getHeapConglomerateId());
        }
        boolean[] blArray = new boolean[stringArray.length];
        int n2 = 0;
        while (n2 < blArray.length) {
            blArray[n2] = true;
            ++n2;
        }
        return this.getGenericConstantActionFactory().getCreateIndexConstantAction(bl, "BTREE", schemaDescriptor.getSchemaName(), string, string2, this.td != null ? this.td.getUUID() : null, 0L, stringArray, blArray, bl2, constraintDefinitionNode.getBackingIndexUUID(), constraintDefinitionNode.getProperties());
    }

    private void checkForDuplicateColumns(DDLStatementNode dDLStatementNode, Hashtable hashtable, String string) throws StandardException {
        String string2 = hashtable.put(string, string);
        if (string2 != null && dDLStatementNode instanceof CreateTableNode) {
            throw StandardException.newException("42X12", string);
        }
    }

    private void checkForDuplicateConstraintNames(DDLStatementNode dDLStatementNode, Hashtable hashtable, String string) throws StandardException {
        if (string == null) {
            return;
        }
        String string2 = hashtable.put(string, string);
        if (string2 != null && dDLStatementNode instanceof CreateTableNode) {
            throw StandardException.newException("42X91", string);
        }
    }

    private void verifyUniqueColumnList(DDLStatementNode dDLStatementNode, ConstraintDefinitionNode constraintDefinitionNode) throws StandardException {
        String string;
        if (dDLStatementNode instanceof CreateTableNode && (string = constraintDefinitionNode.getColumnList().verifyCreateConstraintColumnList(this)) != null) {
            throw StandardException.newException("42X93", dDLStatementNode.getRelativeName(), (Object)string);
        }
        string = constraintDefinitionNode.getColumnList().verifyUniqueNames(false);
        if (string != null) {
            throw StandardException.newException("42X92", string);
        }
    }

    private void setColumnListToNotNull(ConstraintDefinitionNode constraintDefinitionNode, TableDescriptor tableDescriptor) throws StandardException {
        ResultColumnList resultColumnList = constraintDefinitionNode.getColumnList();
        int n = resultColumnList.size();
        int n2 = 0;
        while (n2 < n) {
            ColumnDescriptor columnDescriptor;
            String string = ((ResultColumn)resultColumnList.elementAt(n2)).getName();
            if (tableDescriptor != null && constraintDefinitionNode instanceof ConstraintDefinitionNode && (columnDescriptor = tableDescriptor.getColumnDescriptor(string)) != null && columnDescriptor.getType().isNullable()) {
                throw StandardException.newException("42831", string);
            }
            this.setColumnToNotNull(string);
            ++n2;
        }
    }

    private void setColumnToNotNull(String string) throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            DataTypeDescriptor dataTypeDescriptor;
            ColumnDefinitionNode columnDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(n2);
            if (tableElementNode instanceof ColumnDefinitionNode && string.equals((columnDefinitionNode = (ColumnDefinitionNode)tableElementNode).getColumnName()) && (dataTypeDescriptor = columnDefinitionNode.getDataTypeServices()).isNullable()) {
                throw StandardException.newException("42831", string);
            }
            ++n2;
        }
    }

    public boolean containsColumnName(String string) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(n2);
            if (tableElementNode instanceof ColumnDefinitionNode && string.equals(((ColumnDefinitionNode)tableElementNode).getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

